<?php
require_once __DIR__ . "/../config.php";
require_once __DIR__ . "/../src/lib/helpers.php";

$payload = file_get_contents("php://input");
$sig = $_SERVER["HTTP_STRIPE_SIGNATURE"] ?? "";

if (!verify_stripe_sig($payload, $sig, STRIPE_WEBHOOK_SECRET)) {
  http_response_code(400);
  echo "Invalid signature";
  exit;
}

$event = json_decode($payload, true);
$type = $event["type"] ?? "";

if ($type === "checkout.session.completed") {
  $session = $event["data"]["object"];
  $metadata = $session["metadata"] ?? [];
  // Build customer & item from metadata (you can also expand line items via Stripe API)
  $customer = [
    "name" => $session["customer_details"]["name"] ?? "Customer",
    "email" => $session["customer_details"]["email"] ?? ($metadata["customer_email"] ?? ""),
    "address1" => $session["customer_details"]["address"]["line1"] ?? "Address",
    "city" => $session["customer_details"]["address"]["city"] ?? "",
    "state_code" => $session["customer_details"]["address"]["state"] ?? "",
    "country_code" => $session["customer_details"]["address"]["country"] ?? "US",
    "zip" => $session["customer_details"]["address"]["postal_code"] ?? ""
  ];
  $item = [
    "title" => $metadata["title"] ?? "Art Print",
    "image_url" => $metadata["image_url"] ?? "",
    "size" => $metadata["size"] ?? "18x24",
    "quantity" => intval($metadata["quantity"] ?? 1)
  ];
  global $SIZE_MAP;
  try {
    $placed = place_printful_order($customer, $item, $SIZE_MAP);
    app_log("Stripe webhook Printful order placed: " . json_encode($placed));
  } catch (Exception $e) { app_log("Printful order error: " . $e->getMessage()); }
}

http_response_code(200);
echo "ok";
