<?php
require_once __DIR__ . "/../config.php";
require_once __DIR__ . "/../src/lib/helpers.php";

$payload = json_decode(file_get_contents("php://input"), true);
$amount = intval($payload["amount_cents"] ?? 0);
$item = $payload["item"] ?? [];
$customer = $payload["customer"] ?? [];

if ($amount <= 0) { http_response_code(400); echo json_encode(["error"=>"bad amount"]); exit; }

$domain = APP_BASE_URL;
$metadata = [
  "title" => $item["title"] ?? "",
  "image_url" => $item["image_url"] ?? "",
  "size" => $item["size"] ?? "",
  "quantity" => (string)($item["quantity"] ?? 1),
  "customer_email" => $customer["email"] ?? ""
];

$session = stripe_request("/v1/checkout/sessions", [
  "mode" => "payment",
  "success_url" => $domain . "/public/thankyou.php?session_id={CHECKOUT_SESSION_ID}",
  "cancel_url" => $domain . "/public/cancel.php",
  "payment_method_types[]" => "card",
  "line_items[0][price_data][currency]" => "usd",
  "line_items[0][price_data][product_data][name]" => $item["title"] ?? "Art Print",
  "line_items[0][price_data][unit_amount]" => $amount,
  "line_items[0][quantity]" => 1,
  "metadata[title]" => $metadata["title"],
  "metadata[image_url]" => $metadata["image_url"],
  "metadata[size]" => $metadata["size"],
  "metadata[quantity]" => $metadata["quantity"],
  "customer_email" => $customer["email"] ?? null
]);

header("Content-Type: application/json");
echo json_encode($session ?? ["error"=>"stripe failed"]);
