<?php
require_once __DIR__ . "/../config.php";
require_once __DIR__ . "/../src/lib/helpers.php";

$payload = json_decode(file_get_contents("php://input"), true);
$cap = $payload["capture"] ?? [];

// In a real app, persist item + customer details before payment and reload them here.
// For brevity, this is a placeholder. Replace with your stored checkout data.
$customer = [
  "name" => "PayPal Customer",
  "email" => "customer@example.com",
  "address1" => "Address Line",
  "city" => "City",
  "state_code" => "CA",
  "country_code" => "US",
  "zip" => "94105"
];
$item = [
  "title" => "Art Print",
  "image_url" => "https://via.placeholder.com/1200x1600.png?text=Art+Print",
  "size" => "18x24",
  "quantity" => 1
];

global $SIZE_MAP;
try {
  $placed = place_printful_order($customer, $item, $SIZE_MAP);
  header("Content-Type: " . "application/json");
  echo json_encode(["ok"=>true, "placed"=>$placed]);
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode(["error"=>$e->getMessage()]);
}
