<?php
require_once __DIR__ . "/../config.php";
require_once __DIR__ . "/../src/lib/helpers.php";

$payload = json_decode(file_get_contents("php://input"), true);
$amount = intval($payload["amount_cents"] ?? 0) / 100.0;
$item = $payload["item"] ?? [];
$customer = $payload["customer"] ?? [];

$token = paypal_access_token();
$order = paypal_request("POST", "/v2/checkout/orders", [
  "intent" => "CAPTURE",
  "purchase_units" => [[
    "amount" => [ "currency_code" => "USD", "value" => number_format($amount, 2, ".", "") ],
    "description" => $item["title"] ?? "Art Print"
  ]],
  "payer" => [
    "email_address" => $customer["email"] ?? null,
    "name" => [ "given_name" => $customer["name"] ?? "Customer" ]
  ],
  "application_context" => [
    "return_url" => APP_BASE_URL . "/public/thankyou.php",
    "cancel_url" => APP_BASE_URL . "/public/cancel.php"
  ]
], $token);

header("Content-Type: application/json");
echo json_encode($order ?? ["error"=>"paypal create failed"]);
