<?php
require_once __DIR__ . "/../config.php";
require_once __DIR__ . "/../src/lib/helpers.php";

$payload = json_decode(file_get_contents("php://input"), true);
$orderID = $payload["orderID"] ?? null;
if (!$orderID) { http_response_code(400); echo json_encode(["error"=>"missing orderID"]); exit; }

$token = paypal_access_token();
$capture = paypal_request("POST", "/v2/checkout/orders/$orderID/capture", null, $token);

header("Content-Type: application/json");
echo json_encode($capture ?? ["error"=>"paypal capture failed"]);
