<?php
require_once __DIR__ . "/../config.php";
require_once __DIR__ . "/../data/paintings.php";

$slug = $_GET['slug'] ?? '';
$painting = null;
foreach ($PAINTINGS as $p) {
  if ($p['slug'] === $slug) { $painting = $p; break; }
}
if (!$painting) { http_response_code(404); echo "Not found"; exit; }
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <title><?= htmlspecialchars($painting['title']) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body { font-family: system-ui, Arial, sans-serif; margin: 2rem; max-width: 900px; }
    img { width: 100%; height: auto; border-radius: 8px; }
    form { margin-top: 1rem; display: grid; gap: .75rem; }
    input, select { padding: .6rem; font-size: 1rem; }
    .btn { padding:.7rem 1rem; border-radius:8px; border:1px solid #333; background:#111; color:#fff; }
  </style>
</head>
<body>
  <a href="index.php">&larr; All paintings</a>
  <h1><?= htmlspecialchars($painting['title']) ?></h1>
  <img src="<?= htmlspecialchars($painting['image_url']) ?>" alt="<?= htmlspecialchars($painting['title']) ?>">

  <form action="checkout.php" method="post">
    <input type="hidden" name="title" value="<?= htmlspecialchars($painting['title']) ?>">
    <input type="hidden" name="image_url" value="<?= htmlspecialchars($painting['image_url']) ?>">

    <label>Size</label>
    <select name="size" required>
      <?php foreach ($painting['sizes'] as $size): ?>
        <option value="<?= htmlspecialchars($size) ?>"><?= htmlspecialchars($size) ?></option>
      <?php endforeach; ?>
    </select>

    <label>Quantity</label>
    <input type="number" name="quantity" min="1" value="1" required>

    <button class="btn" type="submit">Order Print</button>
  </form>
</body>
</html>
