<?php
require_once __DIR__ . "/../config.php";
require_once __DIR__ . "/../data/paintings.php";
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <title>Art Prints</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body { font-family: system-ui, Arial, sans-serif; margin: 2rem; }
    .grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(280px, 1fr)); gap: 1.5rem; }
    .card { border: 1px solid #ddd; border-radius: 12px; padding: 1rem; }
    img { width: 100%; height: auto; border-radius: 8px; }
    .btn { display:inline-block; padding:.6rem 1rem; border-radius:8px; border:1px solid #333; text-decoration:none; }
  </style>
</head>
<body>
  <h1>Available Paintings</h1>
  <div class="grid">
    <?php foreach ($PAINTINGS as $p): ?>
      <div class="card">
        <img src="<?= htmlspecialchars($p['image_url']) ?>" alt="<?= htmlspecialchars($p['title']) ?>">
        <h3><?= htmlspecialchars($p['title']) ?></h3>
        <a class="btn" href="painting.php?slug=<?= urlencode($p['slug']) ?>">View</a>
      </div>
    <?php endforeach; ?>
  </div>
</body>
</html>
