<?php
require_once __DIR__ . "/../config.php";
require_once __DIR__ . "/../data/paintings.php";

$title = $_POST['title'] ?? null;
$image_url = $_POST['image_url'] ?? null;
$size = $_POST['size'] ?? null;
$quantity = max(1, intval($_POST['quantity'] ?? 1));

if (!$title || !$image_url || !$size) { http_response_code(422); echo "Missing fields"; exit; }

// Determine price from your data
$price_cents = 4999;
foreach ($PAINTINGS as $p) {
  if ($p["title"] === $title && isset($p["price_map"][$size])) {
    $price_cents = intval($p["price_map"][$size]);
    break;
  }
}
$total_cents = $price_cents * $quantity;
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <title>Checkout - <?= htmlspecialchars($title) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <script src="https://js.stripe.com/v3/"></script>
  <script src="https://www.paypal.com/sdk/js?client-id=<?= htmlspecialchars(PAYPAL_CLIENT_ID) ?>&currency=USD"></script>
  <style>
    body { font-family: system-ui, Arial, sans-serif; margin: 2rem; max-width: 900px; }
    .grid { display:grid; grid-template-columns: 1fr 1fr; gap: 2rem; }
    .card { border: 1px solid #ddd; border-radius: 12px; padding: 1rem; }
    input, select { width:100%; padding:.6rem; margin:.3rem 0; }
    .btn { padding:.7rem 1rem; border-radius:8px; border:1px solid #333; background:#111; color:#fff; }
    #paypal-button-container { margin-top: 1rem; }
  </style>
</head>
<body>
  <a href="javascript:history.back()">&larr; Back</a>
  <h1>Checkout</h1>
  <div class="grid">
    <div class="card">
      <h3>Order</h3>
      <p><strong><?= htmlspecialchars($title) ?></strong></p>
      <p>Size: <?= htmlspecialchars($size) ?> × Qty: <?= htmlspecialchars($quantity) ?></p>
      <p>Total: $<?= number_format($total_cents/100, 2) ?></p>
      <img src="<?= htmlspecialchars($image_url) ?>" style="max-width:100%;border-radius:8px" alt="">
    </div>
    <div class="card">
      <h3>Shipping details</h3>
      <form id="customer-form">
        <input name="name" placeholder="Full name" required>
        <input name="email" type="email" placeholder="Email" required>
        <input name="address1" placeholder="Address line 1" required>
        <input name="city" placeholder="City" required>
        <input name="state_code" placeholder="State (e.g., CA)" required>
        <input name="zip" placeholder="ZIP" required>
        <input name="country_code" placeholder="Country (e.g., US)" value="US" required>
      </form>

      <h3>Pay with Stripe</h3>
      <button class="btn" id="stripe-btn">Pay with Card</button>

      <h3 style="margin-top:1.5rem;">Or Pay with PayPal</h3>
      <div id="paypal-button-container"></div>
    </div>
  </div>

<script>
const totalCents = <?= json_encode($total_cents) ?>;
const item = <?= json_encode(["title"=>$title, "image_url"=>$image_url, "size"=>$size, "quantity"=>$quantity]) ?>;

function formDataObj(form) {
  const fd = new FormData(form);
  const o = {};
  for (const [k,v] of fd.entries()) o[k]=v;
  return o;
}

// Stripe Checkout
document.getElementById("stripe-btn").addEventListener("click", async () => {
  const customer = formDataObj(document.getElementById("customer-form"));
  const resp = await fetch("stripe_create_checkout.php", {
    method: "POST",
    headers: {"Content-Type": "application/json"},
    body: JSON.stringify({ amount_cents: totalCents, item, customer })
  });
  const data = await resp.json();
  if (!data.id || !data.url) { alert("Stripe error"); console.error(data); return; }
  window.location = data.url;
});

// PayPal Buttons
paypal.Buttons({
  createOrder: async function(data, actions) {
    const customer = formDataObj(document.getElementById("customer-form"));
    const resp = await fetch("paypal_create_order.php", {
      method: "POST",
      headers: {"Content-Type": "application/json"},
      body: JSON.stringify({ amount_cents: totalCents, item, customer })
    });
    const out = await resp.json();
    return out.id; // PayPal order ID
  },
  onApprove: async function(data, actions) {
    const resp = await fetch("paypal_capture.php", {
      method: "POST",
      headers: {"Content-Type": "application/json"},
      body: JSON.stringify({ orderID: data.orderID })
    });
    const out = await resp.json();
    if (out.status === "COMPLETED") {
      // Place Printful order after capture
      const place = await fetch("place_printful_after_payment.php", {
        method: "POST",
        headers: {"Content-Type":"application/json"},
        body: JSON.stringify({ capture: out })
      });
      const placed = await place.json();
      alert("Order placed! Check your email.");
      window.location = "thankyou.php";
    } else {
      alert("Payment not completed.");
    }
  }
}).render('#paypal-button-container');
</script>
</body>
</html>
